/*
 * Decompiled with CFR 0.152.
 */
package org.apache.soap.providers;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.Remote;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.ejb.EJBHome;
import javax.ejb.EJBObject;
import javax.ejb.Handle;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpSession;
import org.apache.soap.Constants;
import org.apache.soap.Envelope;
import org.apache.soap.SOAPException;
import org.apache.soap.encoding.soapenc.Base64;
import org.apache.soap.rpc.Call;
import org.apache.soap.rpc.Parameter;
import org.apache.soap.rpc.RPCConstants;
import org.apache.soap.rpc.RPCMessage;
import org.apache.soap.rpc.Response;
import org.apache.soap.rpc.SOAPContext;
import org.apache.soap.server.DeploymentDescriptor;
import org.apache.soap.util.Bean;
import org.apache.soap.util.MethodUtils;
import org.apache.soap.util.Provider;

public class StatefulEJBProvider
implements Provider {
    public static String CNTXT_PROVIDER_URL = "iiop://localhost:900";
    public static String CNTXT_FACTORY_NAME = "com.ibm.ejs.ns.jndi.CNInitialContextFactory";
    protected boolean isCreate = false;
    protected String ejbKey = null;
    public static String DELIM_CHAR = "@";
    private DeploymentDescriptor dd;
    private Envelope envelope;
    private Call call;
    private String targetObjectURI;
    private HttpServlet servlet;
    private HttpSession session;
    private Context contxt = null;
    private Remote remoteObjRef = null;
    private String methodName = null;
    private Vector methodParameters = null;
    private String respEncStyle = null;

    public EJBObject deSerialize(String string) throws SOAPException {
        try {
            byte[] byArray = Base64.decode(string);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            Handle handle = (Handle)objectInputStream.readObject();
            objectInputStream.close();
            return handle.getEJBObject();
        }
        catch (Exception exception) {
            throw new SOAPException(Constants.FAULT_CODE_SERVER, exception.toString());
        }
    }

    public Call getCall() {
        return this.call;
    }

    public Context getContxt() {
        return this.contxt;
    }

    public DeploymentDescriptor getDd() {
        return this.dd;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public Vector getMethodParameters() {
        return this.methodParameters;
    }

    public Remote getRemoteObjRef() {
        return this.remoteObjRef;
    }

    public String getRespEncStyle() {
        return this.respEncStyle;
    }

    public HttpServlet getServlet() {
        return this.servlet;
    }

    public HttpSession getSession() {
        return this.session;
    }

    public String getTargetObjectURI() {
        return this.targetObjectURI;
    }

    public static String getUniqueId(String string) {
        int n = string.indexOf(DELIM_CHAR);
        if (n > 0) {
            return string.substring(n + 1);
        }
        return null;
    }

    protected void initialize(String string, String string2) throws SOAPException {
        if (this.contxt == null) {
            Properties properties = new Properties();
            ((Hashtable)properties).put("java.naming.provider.url", string);
            ((Hashtable)properties).put("java.naming.factory.initial", string2);
            try {
                this.contxt = new InitialContext(properties);
            }
            catch (NamingException namingException) {
                throw new SOAPException(Constants.FAULT_CODE_SERVER, "Unable to initialize context");
            }
        }
    }

    public void invoke(SOAPContext sOAPContext, SOAPContext sOAPContext2) throws SOAPException {
        Object object;
        Object object2;
        Object object3;
        Parameter parameter = null;
        Object[] objectArray = null;
        Class[] classArray = null;
        this.respEncStyle = this.call.getEncodingStyleURI();
        if (this.methodParameters != null) {
            int n = this.methodParameters.size();
            objectArray = new Object[n];
            classArray = new Class[n];
            int n2 = 0;
            while (n2 < n) {
                object3 = (Parameter)this.methodParameters.elementAt(n2);
                objectArray[n2] = ((Parameter)object3).getValue();
                classArray[n2] = ((Parameter)object3).getType();
                if (this.respEncStyle == null) {
                    this.respEncStyle = ((Parameter)object3).getEncodingStyleURI();
                }
                ++n2;
            }
        }
        if (this.respEncStyle == null) {
            this.respEncStyle = "http://schemas.xmlsoap.org/soap/encoding/";
        }
        try {
            object2 = MethodUtils.getMethod(this.remoteObjRef, this.methodName, classArray);
            object = new Bean(((Method)object2).getReturnType(), ((Method)object2).invoke((Object)this.remoteObjRef, objectArray));
            if (((Bean)object).type != Void.TYPE) {
                parameter = new Parameter(RPCConstants.ELEM_RETURN, ((Bean)object).type, ((Bean)object).value, null);
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            throw new SOAPException(Constants.FAULT_CODE_SERVER, throwable.getMessage(), throwable);
        }
        catch (Throwable throwable) {
            throw new SOAPException(Constants.FAULT_CODE_SERVER, throwable.getMessage(), throwable);
        }
        if (this.isCreate) {
            try {
                this.remoteObjRef = (Remote)parameter.getValue();
            }
            catch (ClassCastException classCastException) {
                object2 = (Enumeration)parameter.getValue();
                this.remoteObjRef = (Remote)object2.nextElement();
            }
            parameter = null;
        }
        if (this.ejbKey == null) {
            this.serialize();
        }
        try {
            object2 = new Response(this.targetObjectURI, this.call.getMethodName(), parameter, null, null, this.respEncStyle, sOAPContext2);
            ((RPCMessage)object2).setFullTargetObjectURI(String.valueOf(this.targetObjectURI) + DELIM_CHAR + this.ejbKey);
            object = ((Response)object2).buildEnvelope();
            object3 = new StringWriter();
            ((Envelope)object).marshall((Writer)object3, this.call.getSOAPMappingRegistry(), sOAPContext2);
            sOAPContext2.setRootPart(((StringWriter)object3).toString(), "text/xml;charset=utf-8");
        }
        catch (Exception exception) {
            if (exception instanceof SOAPException) {
                throw (SOAPException)exception;
            }
            throw new SOAPException(Constants.FAULT_CODE_SERVER, exception.toString());
        }
    }

    public void locate(DeploymentDescriptor deploymentDescriptor, Envelope envelope, Call call, String string, String string2, SOAPContext sOAPContext) throws SOAPException {
        HttpServlet httpServlet = (HttpServlet)sOAPContext.getProperty(Constants.BAG_HTTPSERVLET);
        HttpSession httpSession = (HttpSession)sOAPContext.getProperty(Constants.BAG_HTTPSESSION);
        this.dd = deploymentDescriptor;
        this.envelope = envelope;
        this.call = call;
        this.targetObjectURI = call.getTargetObjectURI();
        this.servlet = httpServlet;
        this.session = httpSession;
        this.methodName = call.getMethodName();
        this.methodParameters = call.getParams();
        String string3 = call.getFullTargetObjectURI();
        this.ejbKey = StatefulEJBProvider.getUniqueId(string3);
        if (this.ejbKey != null) {
            this.remoteObjRef = this.deSerialize(this.ejbKey);
            return;
        }
        Hashtable hashtable = this.dd.getProps();
        String string4 = (String)hashtable.get("ContextProviderURL");
        String string5 = (String)hashtable.get("FullContextFactoryName");
        if (string4 != null && string5 != null) {
            this.initialize(string4, string5);
        } else {
            this.initialize(CNTXT_PROVIDER_URL, CNTXT_FACTORY_NAME);
        }
        String string6 = (String)hashtable.get("FullHomeInterfaceName");
        if (string6 == null) {
            throw new SOAPException(Constants.FAULT_CODE_SERVER, "Error in Deployment Descriptor Property Settings");
        }
        String string7 = (String)hashtable.get("JNDIName");
        if (string7 == null) {
            string7 = this.dd.getProviderClass();
        }
        if (string7 != null && this.contxt != null) {
            try {
                EJBHome eJBHome = (EJBHome)PortableRemoteObject.narrow((Object)this.contxt.lookup(string7), Class.forName(string6));
                if (string.equals("create")) {
                    this.remoteObjRef = eJBHome;
                    this.isCreate = true;
                    return;
                }
                Method method = eJBHome.getClass().getMethod("create", new Class[0]);
                this.remoteObjRef = (EJBObject)method.invoke((Object)eJBHome, new Object[0]);
            }
            catch (Exception exception) {
                throw new SOAPException(Constants.FAULT_CODE_SERVER, "Error in connecting to EJB" + exception.toString());
            }
        }
    }

    public void serialize() throws SOAPException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(((EJBObject)this.remoteObjRef).getHandle());
            objectOutputStream.flush();
            objectOutputStream.close();
            this.ejbKey = Base64.encode(byteArrayOutputStream.toByteArray());
        }
        catch (Exception exception) {
            throw new SOAPException(Constants.FAULT_CODE_SERVER, exception.toString());
        }
    }

    public void setCall(Call call) {
        this.call = call;
    }

    public void setContxt(Context context) {
        this.contxt = context;
    }

    public void setDd(DeploymentDescriptor deploymentDescriptor) {
        this.dd = deploymentDescriptor;
    }

    public void setMethodName(String string) {
        this.methodName = string;
    }

    public void setMethodParameters(Vector vector) {
        this.methodParameters = vector;
    }

    public void setRemoteObjRef(Remote remote) {
        this.remoteObjRef = remote;
    }

    public void setRespEncStyle(String string) {
        this.respEncStyle = string;
    }

    public void setServlet(HttpServlet httpServlet) {
        this.servlet = httpServlet;
    }

    public void setSession(HttpSession httpSession) {
        this.session = httpSession;
    }

    public void setTargetObjectURI(String string) {
        this.targetObjectURI = string;
    }
}

