/*
 * Decompiled with CFR 0.152.
 */
package org.jdom.input;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Stack;
import org.jdom.Attribute;
import org.jdom.CDATA;
import org.jdom.Comment;
import org.jdom.DocType;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Entity;
import org.jdom.Namespace;
import org.jdom.ProcessingInstruction;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

class SAXHandler
extends DefaultHandler
implements LexicalHandler {
    private Document document;
    private Stack stack;
    private boolean atRoot;
    private boolean inDTD;
    private boolean inCDATA;
    private boolean inEntity;
    private LinkedList declaredNamespaces;
    private LinkedList availableNamespaces;

    public SAXHandler(Document document) throws IOException {
        this.document = document;
        this.atRoot = true;
        this.stack = new Stack();
        this.declaredNamespaces = new LinkedList();
        this.availableNamespaces = new LinkedList();
        this.availableNamespaces.add(Namespace.XML_NAMESPACE);
        this.inEntity = false;
        this.inDTD = false;
        this.inCDATA = false;
    }

    public void characters(char[] ch, int start, int end) throws SAXException {
        String data = new String(ch, start, end);
        if (this.inCDATA) {
            ((Element)this.stack.peek()).addContent(new CDATA(data));
        } else if (this.inEntity) {
            ((Entity)this.stack.peek()).setContent(data);
        } else {
            Element e = (Element)this.stack.peek();
            e.addContent(data);
        }
    }

    public void comment(char[] ch, int start, int end) throws SAXException {
        String commentText = new String(ch, start, end);
        if (!this.inDTD && !commentText.equals("")) {
            if (this.stack.empty()) {
                this.document.addContent(new Comment(commentText));
            } else {
                ((Element)this.stack.peek()).addContent(new Comment(commentText));
            }
        }
    }

    public void endCDATA() throws SAXException {
        this.inCDATA = false;
    }

    public void endDTD() throws SAXException {
        this.inDTD = false;
    }

    public void endElement(String namespaceURI, String localName, String rawName) {
        Element element = (Element)this.stack.pop();
        if (this.stack.empty()) {
            this.atRoot = true;
        }
        this.availableNamespaces.remove(element.getAdditionalNamespaces());
    }

    public void endEntity(String name) throws SAXException {
        if (this.inEntity) {
            this.stack.pop();
            this.inEntity = false;
        }
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        Iterator itr = this.availableNamespaces.iterator();
        while (itr.hasNext()) {
            Namespace ns = (Namespace)itr.next();
            if (!prefix.equals(ns.getPrefix())) continue;
            itr.remove();
            return;
        }
    }

    private Namespace getNamespace(String prefix) {
        Iterator i = this.availableNamespaces.iterator();
        while (i.hasNext()) {
            Namespace ns = (Namespace)i.next();
            if (!prefix.equals(ns.getPrefix())) continue;
            return ns;
        }
        return Namespace.NO_NAMESPACE;
    }

    public void processingInstruction(String target, String data) throws SAXException {
        if (this.atRoot) {
            this.document.addContent(new ProcessingInstruction(target, data));
        } else {
            ((Element)this.stack.peek()).addContent(new ProcessingInstruction(target, data));
        }
    }

    public void startCDATA() throws SAXException {
        this.inCDATA = true;
    }

    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        this.document.setDocType(new DocType(name, publicId, systemId));
        this.inDTD = true;
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        Element element = null;
        if (namespaceURI != null && !namespaceURI.equals("")) {
            String prefix = "";
            if (localName != qName) {
                int split = qName.indexOf(":");
                prefix = qName.substring(0, split);
            }
            Namespace elementNamespace = Namespace.getNamespace(prefix, namespaceURI);
            element = new Element(localName, elementNamespace);
            this.declaredNamespaces.remove(elementNamespace);
            this.availableNamespaces.addFirst(elementNamespace);
        } else {
            element = new Element(localName);
        }
        this.transferNamespaces(element);
        int i = 0;
        int len = atts.getLength();
        while (i < len) {
            String attQName;
            Attribute attribute = null;
            String attLocalName = atts.getLocalName(i);
            if (attLocalName != (attQName = atts.getQName(i))) {
                String attPrefix = attQName.substring(0, attQName.indexOf(":"));
                attribute = new Attribute(attLocalName, atts.getValue(i), this.getNamespace(attPrefix));
            } else {
                attribute = new Attribute(attLocalName, atts.getValue(i));
            }
            element.addAttribute(attribute);
            ++i;
        }
        if (this.atRoot) {
            this.document.setRootElement(element);
            this.stack.push(element);
            this.atRoot = false;
        } else {
            ((Element)this.stack.peek()).addContent(element);
            this.stack.push(element);
        }
    }

    public void startEntity(String name) throws SAXException {
        if (!(this.inDTD || name.equals("amp") || name.equals("lt") || name.equals("gt") || name.equals("apos") || name.equals("quot"))) {
            Entity entity = new Entity(name);
            ((Element)this.stack.peek()).addContent(entity);
            this.stack.push(entity);
            this.inEntity = true;
        }
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        Namespace ns = Namespace.getNamespace(prefix, uri);
        this.declaredNamespaces.add(ns);
    }

    private void transferNamespaces(Element element) {
        Iterator i = this.declaredNamespaces.iterator();
        while (i.hasNext()) {
            Namespace ns = (Namespace)i.next();
            i.remove();
            this.availableNamespaces.addFirst(ns);
            element.addNamespaceDeclaration(ns);
        }
    }
}

