/*
 * Decompiled with CFR 0.152.
 */
package org.jdom;

import java.io.Serializable;

public class DocType
implements Serializable,
Cloneable {
    protected String elementName;
    protected String publicID;
    protected String systemID;

    protected DocType() {
    }

    public DocType(String elementName) {
        this(elementName, "", "");
    }

    public DocType(String elementName, String systemID) {
        this(elementName, "", systemID);
    }

    public DocType(String elementName, String publicID, String systemID) {
        this.elementName = elementName;
        this.publicID = publicID;
        this.systemID = systemID;
    }

    public Object clone() {
        DocType docType = new DocType(this.elementName, this.publicID, this.systemID);
        return docType;
    }

    public final boolean equals(Object ob) {
        return ob == this;
    }

    public String getElementName() {
        return this.elementName;
    }

    public String getPublicID() {
        return this.publicID;
    }

    public final String getSerializedForm() {
        boolean hasPublic = false;
        StringBuffer serForm = new StringBuffer().append("<!DOCTYPE ").append(this.elementName);
        if (this.publicID != null && !this.publicID.equals("")) {
            serForm.append(" PUBLIC \"").append(this.publicID).append("\"");
            hasPublic = true;
        }
        if (this.systemID != null && !this.systemID.equals("")) {
            if (!hasPublic) {
                serForm.append(" SYSTEM");
            }
            serForm.append(" \"").append(this.systemID).append("\"");
        }
        serForm.append(">");
        return serForm.toString();
    }

    public String getSystemID() {
        return this.systemID;
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public DocType setPublicID(String publicID) {
        this.publicID = publicID;
        return this;
    }

    public DocType setSystemID(String systemID) {
        this.systemID = systemID;
        return this;
    }

    public String toString() {
        return "[DocType: " + this.getSerializedForm() + "]";
    }
}

