/*
 * Decompiled with CFR 0.152.
 */
package org.jdom;

import java.io.Serializable;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.IllegalDataException;
import org.jdom.Verifier;

public class Comment
implements Serializable,
Cloneable {
    protected String text;
    protected Element parent;
    protected Document document;

    protected Comment() {
    }

    public Comment(String text) {
        this.setText(text);
    }

    public Object clone() {
        Comment comment = new Comment(this.text);
        return comment;
    }

    public final boolean equals(Object ob) {
        return ob == this;
    }

    public Document getDocument() {
        if (this.document != null) {
            return this.document;
        }
        Element p = this.getParent();
        if (p != null) {
            return p.getDocument();
        }
        return null;
    }

    public Element getParent() {
        return this.parent;
    }

    public final String getSerializedForm() {
        return "<!--" + this.text + "-->";
    }

    public String getText() {
        return this.text;
    }

    public final int hashCode() {
        return super.hashCode();
    }

    protected Comment setDocument(Document document) {
        this.document = document;
        return this;
    }

    protected Comment setParent(Element parent) {
        this.parent = parent;
        return this;
    }

    public Comment setText(String text) {
        String reason = Verifier.checkCommentData(text);
        if (reason != null) {
            throw new IllegalDataException(text, "comment", reason);
        }
        this.text = text;
        return this;
    }

    public String toString() {
        return "[Comment: " + this.getSerializedForm() + "]";
    }
}

