/*
 * Decompiled with CFR 0.152.
 */
package org.jdom.output;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.jdom.Attribute;
import org.jdom.CDATA;
import org.jdom.Comment;
import org.jdom.DocType;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Entity;
import org.jdom.Namespace;
import org.jdom.ProcessingInstruction;
import org.jdom.output.NamespaceStack;

public class XMLOutputter
implements Cloneable {
    protected static final String STANDARD_INDENT = "  ";
    private boolean suppressDeclaration = false;
    private String encoding = "UTF8";
    private boolean omitEncoding = false;
    private String indent = null;
    private int indentLevel = 0;
    private boolean expandEmptyElements = false;
    private boolean newlines = false;
    private String lineSeparator = "\r\n";
    private boolean trimText = false;
    private boolean padText = false;
    protected String padTextString = " ";
    static /* synthetic */ Class class$org$jdom$Comment;
    static /* synthetic */ Class class$org$jdom$Element;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$jdom$Entity;
    static /* synthetic */ Class class$org$jdom$ProcessingInstruction;
    static /* synthetic */ Class class$org$jdom$CDATA;

    public XMLOutputter() {
    }

    public XMLOutputter(String indent) {
        this.indent = indent;
    }

    public XMLOutputter(String indent, boolean newlines) {
        this.indent = indent;
        this.newlines = newlines;
    }

    public XMLOutputter(String indent, boolean newlines, String encoding) {
        this.indent = indent;
        this.newlines = newlines;
        this.encoding = encoding;
    }

    public XMLOutputter(XMLOutputter that) {
        this.suppressDeclaration = that.suppressDeclaration;
        this.omitEncoding = that.omitEncoding;
        this.indent = that.indent;
        this.indentLevel = that.indentLevel;
        this.expandEmptyElements = that.expandEmptyElements;
        this.newlines = that.newlines;
        this.encoding = that.encoding;
        this.lineSeparator = that.lineSeparator;
        this.trimText = that.trimText;
        this.padText = that.padText;
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    protected String escapeAttributeEntities(String st) {
        StringBuffer buff = new StringBuffer();
        char[] block = st.toCharArray();
        String stEntity = null;
        int i = 0;
        int last = 0;
        while (i < block.length) {
            switch (block[i]) {
                case '<': {
                    stEntity = "&lt;";
                    break;
                }
                case '>': {
                    stEntity = "&gt;";
                    break;
                }
                case '\'': {
                    stEntity = "&apos;";
                    break;
                }
                case '\"': {
                    stEntity = "&quot;";
                    break;
                }
                case '&': {
                    stEntity = "&amp;";
                    break;
                }
            }
            if (stEntity != null) {
                buff.append(block, last, i - last);
                buff.append(stEntity);
                stEntity = null;
                last = i + 1;
            }
            ++i;
        }
        if (last < block.length) {
            buff.append(block, last, i - last);
        }
        return buff.toString();
    }

    protected String escapeElementEntities(String st) {
        StringBuffer buff = new StringBuffer();
        char[] block = st.toCharArray();
        String stEntity = null;
        int i = 0;
        int last = 0;
        while (i < block.length) {
            switch (block[i]) {
                case '<': {
                    stEntity = "&lt;";
                    break;
                }
                case '>': {
                    stEntity = "&gt;";
                    break;
                }
                case '&': {
                    stEntity = "&amp;";
                    break;
                }
            }
            if (stEntity != null) {
                buff.append(block, last, i - last);
                buff.append(stEntity);
                stEntity = null;
                last = i + 1;
            }
            ++i;
        }
        if (last < block.length) {
            buff.append(block, last, i - last);
        }
        return buff.toString();
    }

    protected void indent(Writer out, int level) throws IOException {
        if (this.indent != null && !this.indent.equals("")) {
            int i = 0;
            while (i < level) {
                out.write(this.indent);
                ++i;
            }
        }
    }

    protected Writer makeWriter(OutputStream out) throws UnsupportedEncodingException {
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new BufferedOutputStream(out), this.encoding);
        return writer;
    }

    protected Writer makeWriter(OutputStream out, String encoding) throws UnsupportedEncodingException {
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new BufferedOutputStream(out), encoding);
        return writer;
    }

    protected void maybePrintln(Writer out) throws IOException {
        if (this.newlines) {
            out.write(this.lineSeparator);
        }
    }

    public void output(String string, OutputStream out) throws IOException {
        Writer writer = this.makeWriter(out);
        this.printString(string, writer);
        writer.flush();
    }

    public void output(String string, Writer out) throws IOException {
        this.printString(string, out);
    }

    public void output(CDATA cdata, OutputStream out) throws IOException {
        Writer writer = this.makeWriter(out);
        this.output(cdata, writer);
        writer.flush();
    }

    public void output(CDATA cdata, Writer out) throws IOException {
        this.printCDATASection(cdata, out, this.indentLevel);
    }

    public void output(Comment comment, OutputStream out) throws IOException {
        Writer writer = this.makeWriter(out);
        this.output(comment, writer);
        writer.flush();
    }

    public void output(Comment comment, Writer out) throws IOException {
        this.printComment(comment, out, this.indentLevel);
    }

    public void output(Document doc, OutputStream out) throws IOException {
        Writer writer = this.makeWriter(out);
        this.output(doc, writer);
        writer.flush();
    }

    public void output(Document doc, Writer writer) throws IOException {
        if (this.indentLevel > 0) {
            this.indent(writer, this.indentLevel);
        }
        this.printDeclaration(doc, writer, this.encoding);
        if (doc.getDocType() != null) {
            if (this.indentLevel > 0) {
                this.indent(writer, this.indentLevel);
            }
            this.printDocType(doc.getDocType(), writer);
        }
        Iterator i = doc.getMixedContent().iterator();
        while (i.hasNext()) {
            Object obj = i.next();
            if (obj instanceof Element) {
                this.output(doc.getRootElement(), writer);
                continue;
            }
            if (obj instanceof Comment) {
                this.printComment((Comment)obj, writer, this.indentLevel);
                continue;
            }
            if (obj instanceof ProcessingInstruction) {
                this.printProcessingInstruction((ProcessingInstruction)obj, writer, this.indentLevel);
                continue;
            }
            if (!(obj instanceof CDATA)) continue;
            this.printCDATASection((CDATA)obj, writer, this.indentLevel);
        }
        writer.write(this.lineSeparator);
    }

    public void output(Element element, OutputStream out) throws IOException {
        Writer writer = this.makeWriter(out);
        this.output(element, writer);
        writer.flush();
    }

    public void output(Element element, Writer out) throws IOException {
        this.printElement(element, out, this.indentLevel, new NamespaceStack());
    }

    public void output(Entity entity, OutputStream out) throws IOException {
        Writer writer = this.makeWriter(out);
        this.printEntity(entity, writer);
        writer.flush();
    }

    public void output(Entity entity, Writer out) throws IOException {
        this.printEntity(entity, out);
    }

    public void output(ProcessingInstruction pi, OutputStream out) throws IOException {
        Writer writer = this.makeWriter(out);
        this.output(pi, writer);
        writer.flush();
    }

    public void output(ProcessingInstruction pi, Writer out) throws IOException {
        this.printProcessingInstruction(pi, out, this.indentLevel);
    }

    public void outputElementContent(Element element, Writer out) throws IOException {
        List mixedContent = element.getMixedContent();
        this.printElementContent(element, out, this.indentLevel, new NamespaceStack(), mixedContent);
    }

    public String outputString(Document doc) throws IOException {
        StringWriter out = new StringWriter();
        this.output(doc, (Writer)out);
        out.flush();
        return out.toString();
    }

    public String outputString(Element element) throws IOException {
        StringWriter out = new StringWriter();
        this.output(element, (Writer)out);
        out.flush();
        return out.toString();
    }

    public int parseArgs(String[] args, int i) {
        while (i < args.length) {
            if (args[i].equals("-suppressDeclaration")) {
                this.setSuppressDeclaration(true);
            } else if (args[i].equals("-omitEncoding")) {
                this.setOmitEncoding(true);
            } else if (args[i].equals("-indent")) {
                this.setIndent(args[++i]);
            } else if (args[i].equals("-indentSize")) {
                this.setIndentSize(Integer.parseInt(args[++i]));
            } else if (args[i].equals("-indentLevel")) {
                this.setIndentLevel(Integer.parseInt(args[++i]));
            } else if (args[i].startsWith("-expandEmpty")) {
                this.setExpandEmptyElements(true);
            } else if (args[i].equals("-encoding")) {
                this.setEncoding(args[++i]);
            } else if (args[i].equals("-newlines")) {
                this.setNewlines(true);
            } else if (args[i].equals("-lineSeparator")) {
                this.setLineSeparator(args[++i]);
            } else if (args[i].equals("-trimText")) {
                this.setTrimText(true);
            } else if (args[i].equals("-padText")) {
                this.setPadText(true);
            } else {
                return i;
            }
            ++i;
        }
        return i;
    }

    protected void printAttributes(List attributes, Element parent, Writer out, NamespaceStack namespaces) throws IOException {
        HashSet prefixes = new HashSet();
        int i = 0;
        int size = attributes.size();
        while (i < size) {
            Attribute attribute = (Attribute)attributes.get(i);
            Namespace ns = attribute.getNamespace();
            if (ns != Namespace.NO_NAMESPACE && ns != Namespace.XML_NAMESPACE) {
                String prefix = ns.getPrefix();
                String uri = namespaces.getURI(prefix);
                if (!ns.getURI().equals(uri)) {
                    this.printNamespace(ns, out);
                    namespaces.push(ns);
                }
            }
            out.write(" ");
            out.write(attribute.getQualifiedName());
            out.write("=");
            out.write("\"");
            out.write(this.escapeAttributeEntities(attribute.getValue()));
            out.write("\"");
            ++i;
        }
    }

    protected void printCDATASection(CDATA cdata, Writer out, int indentLevel) throws IOException {
        this.indent(out, indentLevel);
        out.write(cdata.getSerializedForm());
        this.maybePrintln(out);
    }

    protected void printComment(Comment comment, Writer out, int indentLevel) throws IOException {
        this.indent(out, indentLevel);
        out.write(comment.getSerializedForm());
        this.maybePrintln(out);
    }

    protected void printDeclaration(Document doc, Writer out, String encoding) throws IOException {
        if (!this.suppressDeclaration) {
            if (encoding.equals("UTF8")) {
                out.write("<?xml version=\"1.0\"");
                if (!this.omitEncoding) {
                    out.write(" encoding=\"UTF-8\"");
                }
                out.write("?>");
            } else {
                out.write("<?xml version=\"1.0\"");
                if (!this.omitEncoding) {
                    out.write(" encoding=\"" + encoding + "\"");
                }
                out.write("?>");
            }
            out.write(this.lineSeparator);
        }
    }

    protected void printDocType(DocType docType, Writer out) throws IOException {
        if (docType == null) {
            return;
        }
        String publicID = docType.getPublicID();
        String systemID = docType.getSystemID();
        boolean hasPublic = false;
        out.write("<!DOCTYPE ");
        out.write(docType.getElementName());
        if (publicID != null && !publicID.equals("")) {
            out.write(" PUBLIC \"");
            out.write(publicID);
            out.write("\"");
            hasPublic = true;
        }
        if (systemID != null && !systemID.equals("")) {
            if (!hasPublic) {
                out.write(" SYSTEM");
            }
            out.write(" \"");
            out.write(systemID);
            out.write("\"");
        }
        out.write(">");
        this.maybePrintln(out);
    }

    protected void printElement(Element element, Writer out, int indentLevel, NamespaceStack namespaces) throws IOException {
        List additionalNamespaces;
        List mixedContent = element.getMixedContent();
        boolean empty = mixedContent.size() == 0;
        boolean stringOnly = !empty && mixedContent.size() == 1 && mixedContent.get(0) instanceof String;
        this.indent(out, indentLevel);
        out.write("<");
        out.write(element.getQualifiedName());
        int previouslyDeclaredNamespaces = namespaces.size();
        Namespace ns = element.getNamespace();
        if (ns != Namespace.XML_NAMESPACE && (ns != Namespace.NO_NAMESPACE || namespaces.getURI("") != null)) {
            String prefix = ns.getPrefix();
            String uri = namespaces.getURI(prefix);
            if (!ns.getURI().equals(uri)) {
                namespaces.push(ns);
                this.printNamespace(ns, out);
            }
        }
        if ((additionalNamespaces = element.getAdditionalNamespaces()) != null) {
            int i = 0;
            while (i < additionalNamespaces.size()) {
                Namespace additional = (Namespace)additionalNamespaces.get(i);
                String prefix = additional.getPrefix();
                String uri = namespaces.getURI(prefix);
                if (!additional.getURI().equals(uri)) {
                    namespaces.push(additional);
                    this.printNamespace(additional, out);
                }
                ++i;
            }
        }
        this.printAttributes(element.getAttributes(), element, out, namespaces);
        if (stringOnly) {
            String elementText;
            String string = elementText = this.trimText ? element.getTextTrim() : element.getText();
            if (elementText == null || elementText.equals("")) {
                empty = true;
            }
        }
        if (empty) {
            if (!this.expandEmptyElements) {
                out.write(" />");
            } else {
                out.write("></");
                out.write(element.getQualifiedName());
                out.write(">");
            }
            this.maybePrintln(out);
        } else {
            out.write(">");
            if (stringOnly) {
                this.printElementContent(element, out, indentLevel, namespaces, mixedContent);
            } else {
                this.maybePrintln(out);
                this.printElementContent(element, out, indentLevel, namespaces, mixedContent);
                this.indent(out, indentLevel);
            }
            out.write("</");
            out.write(element.getQualifiedName());
            out.write(">");
            this.maybePrintln(out);
        }
        while (namespaces.size() > previouslyDeclaredNamespaces) {
            namespaces.pop();
        }
    }

    protected void printElementContent(Element element, Writer out, int indentLevel, NamespaceStack namespaces, List mixedContent) throws IOException {
        boolean stringOnly;
        boolean empty = mixedContent.size() == 0;
        boolean bl = stringOnly = !empty && mixedContent.size() == 1 && mixedContent.get(0) instanceof String;
        if (stringOnly) {
            String elementText = this.trimText ? element.getTextTrim() : element.getText();
            out.write(this.escapeElementEntities(elementText));
        } else {
            Object content = null;
            Class justOutput = null;
            int i = 0;
            int size = mixedContent.size();
            while (i < size) {
                content = mixedContent.get(i);
                if (content instanceof Comment) {
                    this.printComment(content, out, indentLevel + 1);
                    justOutput = class$org$jdom$Comment != null ? class$org$jdom$Comment : XMLOutputter.class$("org.jdom.Comment");
                } else if (content instanceof String) {
                    if (this.padText && justOutput == (class$org$jdom$Element != null ? class$org$jdom$Element : XMLOutputter.class$("org.jdom.Element"))) {
                        out.write(this.padTextString);
                    }
                    this.printString(content, out);
                    justOutput = class$java$lang$String != null ? class$java$lang$String : XMLOutputter.class$("java.lang.String");
                } else if (content instanceof Element) {
                    if (this.padText && justOutput == (class$java$lang$String != null ? class$java$lang$String : XMLOutputter.class$("java.lang.String"))) {
                        out.write(this.padTextString);
                    }
                    this.printElement(content, out, indentLevel + 1, namespaces);
                    justOutput = class$org$jdom$Element != null ? class$org$jdom$Element : XMLOutputter.class$("org.jdom.Element");
                } else if (content instanceof Entity) {
                    this.printEntity(content, out);
                    justOutput = class$org$jdom$Entity != null ? class$org$jdom$Entity : XMLOutputter.class$("org.jdom.Entity");
                } else if (content instanceof ProcessingInstruction) {
                    this.printProcessingInstruction(content, out, indentLevel + 1);
                    justOutput = class$org$jdom$ProcessingInstruction != null ? class$org$jdom$ProcessingInstruction : XMLOutputter.class$("org.jdom.ProcessingInstruction");
                } else if (content instanceof CDATA) {
                    this.printCDATASection(content, out, indentLevel + 1);
                    justOutput = class$org$jdom$CDATA != null ? class$org$jdom$CDATA : XMLOutputter.class$("org.jdom.CDATA");
                }
                ++i;
            }
        }
    }

    protected void printEntity(Entity entity, Writer out) throws IOException {
        out.write(entity.getSerializedForm());
    }

    protected void printNamespace(Namespace ns, Writer out) throws IOException {
        out.write(" xmlns");
        String prefix = ns.getPrefix();
        if (!prefix.equals("")) {
            out.write(":");
            out.write(prefix);
        }
        out.write("=\"");
        out.write(ns.getURI());
        out.write("\"");
    }

    protected void printProcessingInstruction(ProcessingInstruction pi, Writer out, int indentLevel) throws IOException {
        this.indent(out, indentLevel);
        out.write(pi.getSerializedForm());
        this.maybePrintln(out);
    }

    protected void printString(String s, Writer out) throws IOException {
        s = this.escapeElementEntities(s);
        if (this.trimText) {
            StringTokenizer tokenizer = new StringTokenizer(s);
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                out.write(token);
                if (!tokenizer.hasMoreTokens()) continue;
                out.write(" ");
            }
        } else {
            out.write(s);
        }
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setExpandEmptyElements(boolean expandEmptyElements) {
        this.expandEmptyElements = expandEmptyElements;
    }

    public void setIndent(String indent) {
        if ("".equals(indent)) {
            indent = null;
        }
        this.indent = indent;
    }

    public void setIndent(boolean doIndent) {
        this.indent = doIndent ? STANDARD_INDENT : null;
    }

    public void setIndentLevel(int indentLevel) {
        this.indentLevel = indentLevel;
    }

    public void setIndentSize(int indentSize) {
        StringBuffer indentBuffer = new StringBuffer();
        int i = 0;
        while (i < indentSize) {
            indentBuffer.append(" ");
            ++i;
        }
        this.indent = indentBuffer.toString();
    }

    public void setLineSeparator(String separator) {
        this.lineSeparator = separator;
    }

    public void setNewlines(boolean newlines) {
        this.newlines = newlines;
    }

    public void setOmitEncoding(boolean omitEncoding) {
        this.omitEncoding = omitEncoding;
    }

    public void setPadText(boolean padText) {
        this.padText = padText;
    }

    public void setSuppressDeclaration(boolean suppressDeclaration) {
        this.suppressDeclaration = suppressDeclaration;
    }

    public void setTrimText(boolean trimText) {
        this.trimText = trimText;
    }
}

