/*
 * Decompiled with CFR 0.152.
 */
package org.jdom.output;

import java.util.Stack;
import org.jdom.Namespace;

class NamespaceStack {
    private Stack prefixes = new Stack();
    private Stack uris = new Stack();

    public String getURI(String prefix) {
        int index = this.prefixes.lastIndexOf(prefix);
        if (index == -1) {
            return null;
        }
        String uri = (String)this.uris.elementAt(index);
        return uri;
    }

    public String pop() {
        String prefix = (String)this.prefixes.pop();
        this.uris.pop();
        return prefix;
    }

    public void printStack() {
        System.out.println("Stack: " + this.prefixes.size());
        int i = 0;
        while (i < this.prefixes.size()) {
            System.out.println(String.valueOf(String.valueOf(this.prefixes.elementAt(i))) + "&" + this.uris.elementAt(i));
            ++i;
        }
    }

    public void push(Namespace ns) {
        this.prefixes.push(ns.getPrefix());
        this.uris.push(ns.getURI());
    }

    public int size() {
        return this.prefixes.size();
    }
}

