/*
 * Decompiled with CFR 0.152.
 */
package org.jdom.output;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.jdom.Attribute;
import org.jdom.CDATA;
import org.jdom.DocType;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.ProcessingInstruction;
import org.jdom.output.NamespaceStack;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.LocatorImpl;

public class SAXOutputter {
    private ContentHandler contentHandler;
    private ErrorHandler errorHandler;
    private DTDHandler dtdHandler;
    private EntityResolver entityResolver;

    public SAXOutputter(ContentHandler contentHandler) {
        this.contentHandler = contentHandler;
    }

    public SAXOutputter(ContentHandler contentHandler, ErrorHandler errorHandler, DTDHandler dtdHandler, EntityResolver entityResolver) {
        this.contentHandler = contentHandler;
        this.errorHandler = errorHandler;
        this.dtdHandler = dtdHandler;
        this.entityResolver = entityResolver;
    }

    private void characters(String elementText) throws JDOMException {
        char[] c = elementText.toCharArray();
        try {
            this.contentHandler.characters(c, 0, c.length);
        }
        catch (SAXException se) {
            throw new JDOMException("SAXException", se);
        }
    }

    private void documentLocator(Document document) {
        LocatorImpl locator = new LocatorImpl();
        String publicID = null;
        String systemID = null;
        DocType docType = document.getDocType();
        if (docType != null) {
            publicID = docType.getPublicID();
            systemID = docType.getSystemID();
        }
        locator.setPublicId(publicID);
        locator.setSystemId(systemID);
        locator.setLineNumber(-1);
        locator.setColumnNumber(-1);
        this.contentHandler.setDocumentLocator(locator);
    }

    private void element(Element element, NamespaceStack namespaces) throws JDOMException {
        int previouslyDeclaredNamespaces = namespaces.size();
        this.startPrefixMapping(element, namespaces);
        this.startElement(element);
        this.elementContent(element, namespaces);
        this.endElement(element);
        this.endPrefixMapping(namespaces, previouslyDeclaredNamespaces);
    }

    private void elementContent(Element element, NamespaceStack namespaces) throws JDOMException {
        boolean stringOnly;
        List mixedContent = element.getMixedContent();
        boolean empty = mixedContent.size() == 0;
        boolean bl = stringOnly = !empty && mixedContent.size() == 1 && mixedContent.get(0) instanceof String;
        if (stringOnly) {
            this.characters(element.getText());
        } else {
            Object content = null;
            int i = 0;
            int size = mixedContent.size();
            while (i < size) {
                content = mixedContent.get(i);
                if (content instanceof Element) {
                    this.element(content, namespaces);
                } else if (content instanceof String) {
                    this.characters(content);
                } else if (content instanceof CDATA) {
                    this.characters(((CDATA)content).getText());
                } else if (content instanceof ProcessingInstruction) {
                    this.processingInstruction(content);
                }
                ++i;
            }
        }
    }

    private void endDocument() throws JDOMException {
        try {
            this.contentHandler.endDocument();
        }
        catch (SAXException se) {
            throw new JDOMException("SAXException", se);
        }
    }

    private void endElement(Element element) throws JDOMException {
        String namespaceURI = element.getNamespaceURI();
        String localName = element.getName();
        String rawName = element.getQualifiedName();
        try {
            this.contentHandler.endElement(namespaceURI, localName, rawName);
        }
        catch (SAXException se) {
            throw new JDOMException("SAXException", se);
        }
    }

    private void endPrefixMapping(NamespaceStack namespaces, int previouslyDeclaredNamespaces) throws JDOMException {
        while (namespaces.size() > previouslyDeclaredNamespaces) {
            String prefix = namespaces.pop();
            try {
                this.contentHandler.endPrefixMapping(prefix);
            }
            catch (SAXException se) {
                throw new JDOMException("SAXException", se);
            }
        }
    }

    private void entityResolver(Document document) throws JDOMException {
        if (this.entityResolver != null) {
            DocType docType = document.getDocType();
            String publicID = null;
            String systemID = null;
            if (docType != null) {
                publicID = docType.getPublicID();
                systemID = docType.getSystemID();
            }
            if (publicID != null || systemID != null) {
                try {
                    this.entityResolver.resolveEntity(publicID, systemID);
                }
                catch (SAXException se) {
                    throw new JDOMException("SAXException", se);
                }
                catch (IOException ioe) {
                    throw new JDOMException("IOException", ioe);
                }
            }
        }
    }

    public void output(Document document) throws JDOMException {
        if (document == null) {
            return;
        }
        this.documentLocator(document);
        this.startDocument();
        this.entityResolver(document);
        Iterator i = document.getMixedContent().iterator();
        while (i.hasNext()) {
            Object obj = i.next();
            if (obj instanceof Element) {
                this.element(document.getRootElement(), new NamespaceStack());
                continue;
            }
            if (obj instanceof ProcessingInstruction) {
                this.processingInstruction((ProcessingInstruction)obj);
                continue;
            }
            if (!(obj instanceof CDATA)) continue;
            this.characters(((CDATA)obj).getText());
        }
        this.endDocument();
    }

    private void processingInstruction(ProcessingInstruction pi) throws JDOMException {
        if (pi != null) {
            String target = pi.getTarget();
            String data = pi.getData();
            try {
                this.contentHandler.processingInstruction(target, data);
            }
            catch (SAXException se) {
                throw new JDOMException("SAXException", se);
            }
        }
    }

    public void setContentHandler(ContentHandler contentHandler) {
        this.contentHandler = contentHandler;
    }

    public void setDTDHandler(DTDHandler dtdHandler) {
        this.dtdHandler = dtdHandler;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    private void startDocument() throws JDOMException {
        try {
            this.contentHandler.startDocument();
        }
        catch (SAXException se) {
            throw new JDOMException("SAXException", se);
        }
    }

    private void startElement(Element element) throws JDOMException {
        String namespaceURI = element.getNamespaceURI();
        String localName = element.getName();
        String rawName = element.getQualifiedName();
        AttributesImpl atts = new AttributesImpl();
        List attributes = element.getAttributes();
        Iterator i = attributes.iterator();
        while (i.hasNext()) {
            Attribute a = (Attribute)i.next();
            atts.addAttribute(a.getNamespaceURI(), a.getName(), a.getQualifiedName(), "CDATA", a.getValue());
        }
        try {
            this.contentHandler.startElement(namespaceURI, localName, rawName, atts);
        }
        catch (SAXException se) {
            throw new JDOMException("SAXException", se);
        }
    }

    private void startPrefixMapping(Element element, NamespaceStack namespaces) throws JDOMException {
        Namespace ns = element.getNamespace();
        if (ns != Namespace.NO_NAMESPACE && ns != Namespace.XML_NAMESPACE) {
            String prefix = ns.getPrefix();
            String uri = namespaces.getURI(prefix);
            if (!ns.getURI().equals(uri)) {
                namespaces.push(ns);
                try {
                    this.contentHandler.startPrefixMapping(prefix, ns.getURI());
                }
                catch (SAXException se) {
                    throw new JDOMException("SAXException", se);
                }
            }
        }
    }
}

