/*
 * Decompiled with CFR 0.152.
 */
package org.jdom;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import org.jdom.Attribute;
import org.jdom.CDATA;
import org.jdom.Comment;
import org.jdom.Document;
import org.jdom.Entity;
import org.jdom.IllegalAddException;
import org.jdom.IllegalNameException;
import org.jdom.Namespace;
import org.jdom.PartialList;
import org.jdom.ProcessingInstruction;
import org.jdom.Verifier;

public class Element
implements Serializable,
Cloneable {
    protected String name;
    protected transient Namespace namespace;
    protected transient LinkedList additionalNamespaces;
    protected Element parent;
    protected Document document;
    protected List attributes;
    protected LinkedList content;
    static /* synthetic */ Class class$org$jdom$Element;

    protected Element() {
    }

    public Element(String name) {
        this(name, Namespace.NO_NAMESPACE);
    }

    public Element(String name, String uri) {
        this(name, Namespace.getNamespace("", uri));
    }

    public Element(String name, String prefix, String uri) {
        this(name, Namespace.getNamespace(prefix, uri));
    }

    public Element(String name, Namespace namespace) {
        String reason = Verifier.checkElementName(name);
        if (reason != null) {
            throw new IllegalNameException(name, "element", reason);
        }
        this.name = name;
        if (namespace == null) {
            namespace = Namespace.NO_NAMESPACE;
        }
        this.namespace = namespace;
        this.document = null;
    }

    public Element addAttribute(String name, String value) {
        return this.addAttribute(new Attribute(name, value));
    }

    public Element addAttribute(Attribute attribute) {
        if (this.getAttribute(attribute.getName(), attribute.getNamespace()) != null) {
            throw new IllegalAddException(this, attribute, "Duplicate attributes are not allowed");
        }
        if (attribute.getParent() != null) {
            throw new IllegalAddException(this, attribute, "The attribute already has an existing parent \"" + attribute.getParent().getQualifiedName() + "\"");
        }
        if (this.attributes == null) {
            this.attributes = new LinkedList();
        }
        this.attributes.add(attribute);
        attribute.setParent(this);
        return this;
    }

    public Element addContent(String text) {
        Object ob;
        if (this.content == null) {
            this.content = new LinkedList();
        }
        if (this.content.size() > 0 && (ob = this.content.getLast()) instanceof String) {
            text = String.valueOf((String)ob) + text;
            this.content.removeLast();
        }
        this.content.add(text);
        return this;
    }

    public Element addContent(CDATA cdata) {
        if (this.content == null) {
            this.content = new LinkedList();
        }
        this.content.add(cdata);
        return this;
    }

    public Element addContent(Comment comment) {
        if (comment.getParent() != null) {
            throw new IllegalAddException(this, comment, "The comment already has an existing parent \"" + comment.getParent().getQualifiedName() + "\"");
        }
        if (comment.getDocument() != null) {
            throw new IllegalAddException(this, comment, "The comment already has an existing parent (the document root)");
        }
        if (this.content == null) {
            this.content = new LinkedList();
        }
        this.content.add(comment);
        comment.setParent(this);
        return this;
    }

    public Element addContent(Element element) {
        if (element.isRootElement()) {
            throw new IllegalAddException(this, element, "The element already has an existing parent (the document root)");
        }
        if (element.getParent() != null) {
            throw new IllegalAddException(this, element, "The element already has an existing parent \"" + element.getParent().getQualifiedName() + "\"");
        }
        if (element == this) {
            throw new IllegalAddException(this, element, "The element cannot be added to itself");
        }
        if (this.isAncestor(element)) {
            throw new IllegalAddException(this, element, "The element cannot be added as a descendent of itself");
        }
        if (this.content == null) {
            this.content = new LinkedList();
        }
        element.setParent(this);
        this.content.add(element);
        return this;
    }

    public Element addContent(Entity entity) {
        if (entity.getParent() != null) {
            throw new IllegalAddException(this, entity, "The entity already has an existing parent \"" + entity.getParent().getQualifiedName() + "\"");
        }
        if (this.content == null) {
            this.content = new LinkedList();
        }
        this.content.add(entity);
        entity.setParent(this);
        return this;
    }

    public Element addContent(ProcessingInstruction pi) {
        if (pi.getParent() != null) {
            throw new IllegalAddException(this, pi, "The PI already has an existing parent \"" + pi.getParent().getQualifiedName() + "\"");
        }
        if (pi.getDocument() != null) {
            throw new IllegalAddException(this, pi, "The PI already has an existing parent (the document root)");
        }
        if (this.content == null) {
            this.content = new LinkedList();
        }
        this.content.add(pi);
        pi.setParent(this);
        return this;
    }

    public void addNamespaceDeclaration(Namespace additionalNamespace) {
        if (this.additionalNamespaces == null) {
            this.additionalNamespaces = new LinkedList();
        }
        this.additionalNamespaces.add(additionalNamespace);
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public Object clone() {
        Element element = new Element(this.name, this.namespace);
        if (this.attributes != null) {
            LinkedList list = new LinkedList();
            Iterator i = this.attributes.iterator();
            while (i.hasNext()) {
                element.addAttribute((Attribute)((Attribute)i.next()).clone());
            }
        }
        if (this.content != null) {
            Iterator i = this.content.iterator();
            while (i.hasNext()) {
                Object obj = i.next();
                if (obj instanceof String) {
                    element.addContent((String)obj);
                    continue;
                }
                if (obj instanceof Comment) {
                    element.addContent((Comment)((Comment)obj).clone());
                    continue;
                }
                if (obj instanceof Entity) {
                    element.addContent((Entity)((Entity)obj).clone());
                    continue;
                }
                if (obj instanceof Element) {
                    element.addContent((Element)((Element)obj).clone());
                    continue;
                }
                if (!(obj instanceof CDATA)) continue;
                element.addContent((CDATA)((CDATA)obj).clone());
            }
        }
        if (this.additionalNamespaces != null) {
            element.additionalNamespaces = (LinkedList)this.additionalNamespaces.clone();
        }
        element.setParent(null);
        return element;
    }

    public final boolean equals(Object ob) {
        return this == ob;
    }

    public List getAdditionalNamespaces() {
        if (this.additionalNamespaces == null) {
            return Collections.EMPTY_LIST;
        }
        return this.additionalNamespaces;
    }

    public Attribute getAttribute(String name) {
        return this.getAttribute(name, Namespace.NO_NAMESPACE);
    }

    public Attribute getAttribute(String name, Namespace ns) {
        if (this.attributes == null) {
            return null;
        }
        String uri = ns.getURI();
        Iterator i = this.attributes.iterator();
        while (i.hasNext()) {
            Attribute att = (Attribute)i.next();
            if (!att.getNamespaceURI().equals(uri) || !att.getName().equals(name)) continue;
            return att;
        }
        return null;
    }

    public String getAttributeValue(String name) {
        return this.getAttributeValue(name, Namespace.NO_NAMESPACE);
    }

    public String getAttributeValue(String name, Namespace ns) {
        Attribute attrib = this.getAttribute(name, ns);
        if (attrib == null) {
            return null;
        }
        return attrib.getValue();
    }

    public List getAttributes() {
        if (this.attributes == null) {
            this.attributes = new LinkedList();
        }
        PartialList atts = new PartialList(this.attributes, this);
        atts.addAllPartial(this.attributes);
        return atts;
    }

    public Element getChild(String name) {
        return this.getChild(name, Namespace.NO_NAMESPACE);
    }

    public Element getChild(String name, Namespace ns) {
        if (this.content == null) {
            return null;
        }
        String uri = ns.getURI();
        Iterator i = this.content.iterator();
        while (i.hasNext()) {
            Element element;
            Object obj = i.next();
            if (!(obj instanceof Element) || !(element = (Element)obj).getNamespaceURI().equals(uri) || !element.getName().equals(name)) continue;
            return element;
        }
        return null;
    }

    public String getChildText(String name) {
        Element child = this.getChild(name);
        if (child == null) {
            return null;
        }
        return child.getText();
    }

    public String getChildText(String name, Namespace ns) {
        Element child = this.getChild(name, ns);
        if (child == null) {
            return null;
        }
        return child.getText();
    }

    public String getChildTextTrim(String name) {
        Element child = this.getChild(name);
        if (child == null) {
            return null;
        }
        return child.getTextTrim();
    }

    public String getChildTextTrim(String name, Namespace ns) {
        Element child = this.getChild(name, ns);
        if (child == null) {
            return null;
        }
        return child.getTextTrim();
    }

    public List getChildren() {
        if (this.content == null) {
            this.content = new LinkedList();
        }
        PartialList elements = new PartialList(this.content, this);
        Iterator i = this.content.iterator();
        while (i.hasNext()) {
            Object obj = i.next();
            if (!(obj instanceof Element)) continue;
            elements.addPartial(obj);
        }
        return elements;
    }

    public List getChildren(String name) {
        return this.getChildren(name, Namespace.NO_NAMESPACE);
    }

    public List getChildren(String name, Namespace ns) {
        PartialList children = new PartialList(this.getChildren(), this);
        if (this.content != null) {
            String uri = ns.getURI();
            Iterator i = this.content.iterator();
            while (i.hasNext()) {
                Element element;
                Object obj = i.next();
                if (!(obj instanceof Element) || !(element = (Element)obj).getNamespaceURI().equals(uri) || !element.getName().equals(name)) continue;
                children.addPartial(element);
            }
        }
        return children;
    }

    public Element getCopy(String name) {
        return this.getCopy(name, Namespace.NO_NAMESPACE);
    }

    public Element getCopy(String name, Namespace ns) {
        Element clone = (Element)this.clone();
        clone.namespace = ns;
        clone.name = name;
        return clone;
    }

    public Document getDocument() {
        if (this.isRootElement()) {
            return this.document;
        }
        if (this.getParent() != null) {
            return this.getParent().getDocument();
        }
        return null;
    }

    public List getMixedContent() {
        if (this.content == null) {
            this.content = new LinkedList();
        }
        PartialList result = new PartialList(this.content, this);
        result.addAllPartial(this.content);
        return result;
    }

    public String getName() {
        return this.name;
    }

    public Namespace getNamespace() {
        return this.namespace;
    }

    public Namespace getNamespace(String prefix) {
        Element parent;
        if (prefix == null) {
            return null;
        }
        if (prefix.equals(this.getNamespacePrefix())) {
            return this.getNamespace();
        }
        List addl = this.getAdditionalNamespaces();
        if (addl.size() > 0) {
            Iterator itr = addl.iterator();
            while (itr.hasNext()) {
                Namespace ns = (Namespace)itr.next();
                if (!prefix.equals(ns.getPrefix())) continue;
                return ns;
            }
        }
        if ((parent = this.getParent()) != null) {
            return parent.getNamespace(prefix);
        }
        return null;
    }

    public String getNamespacePrefix() {
        return this.namespace.getPrefix();
    }

    public String getNamespaceURI() {
        return this.namespace.getURI();
    }

    public Element getParent() {
        return this.parent;
    }

    public String getQualifiedName() {
        if (this.namespace.getPrefix().equals("")) {
            return this.getName();
        }
        return this.namespace.getPrefix() + ":" + this.name;
    }

    public final String getSerializedForm() {
        throw new RuntimeException("Element.getSerializedForm() is not yet implemented");
    }

    public String getText() {
        if (this.content == null || this.content.size() < 1 || this.content.get(0) == null) {
            return "";
        }
        if (this.content.size() == 1 && this.content.get(0) instanceof String) {
            return (String)this.content.get(0);
        }
        StringBuffer textContent = new StringBuffer();
        boolean hasText = false;
        Iterator i = this.content.iterator();
        while (i.hasNext()) {
            Object obj = i.next();
            if (obj instanceof String) {
                textContent.append((String)obj);
                hasText = true;
                continue;
            }
            if (!(obj instanceof CDATA)) continue;
            textContent.append(((CDATA)obj).getText());
            hasText = true;
        }
        if (!hasText) {
            return "";
        }
        return textContent.toString();
    }

    public String getTextTrim() {
        String text = this.getText();
        StringBuffer textContent = new StringBuffer();
        StringTokenizer tokenizer = new StringTokenizer(text);
        while (tokenizer.hasMoreTokens()) {
            String str = tokenizer.nextToken();
            textContent.append(str);
            if (!tokenizer.hasMoreTokens()) continue;
            textContent.append(" ");
        }
        return textContent.toString();
    }

    public boolean hasChildren() {
        if (this.content == null || this.content.size() == 0) {
            return false;
        }
        Iterator i = this.content.iterator();
        while (i.hasNext()) {
            Object obj = i.next();
            Class<?> objclass = obj.getClass();
            if (objclass != (class$org$jdom$Element != null ? class$org$jdom$Element : Element.class$("org.jdom.Element"))) continue;
            return true;
        }
        return false;
    }

    public boolean hasMixedContent() {
        if (this.content == null) {
            return false;
        }
        Class<?> prevClass = null;
        Iterator i = this.content.iterator();
        while (i.hasNext()) {
            Object obj = i.next();
            Class<?> newClass = obj.getClass();
            if (newClass == prevClass) continue;
            if (prevClass != null) {
                return true;
            }
            prevClass = newClass;
        }
        return false;
    }

    public final int hashCode() {
        return super.hashCode();
    }

    private boolean isAncestor(Element e) {
        Element parent = this.getParent();
        while (parent != null) {
            if (parent == e) {
                return true;
            }
            parent = parent.getParent();
        }
        return false;
    }

    public boolean isRootElement() {
        return this.document != null;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.namespace = Namespace.getNamespace((String)in.readObject(), (String)in.readObject());
    }

    public boolean removeAttribute(String name) {
        return this.removeAttribute(name, Namespace.NO_NAMESPACE);
    }

    public boolean removeAttribute(String name, String uri) {
        Iterator i = this.attributes.iterator();
        while (i.hasNext()) {
            Attribute att = (Attribute)i.next();
            if (!att.getNamespaceURI().equals(uri) || !att.getName().equals(name)) continue;
            i.remove();
            att.setParent(null);
            return true;
        }
        return false;
    }

    public boolean removeAttribute(String name, Namespace ns) {
        if (this.attributes == null) {
            return false;
        }
        String uri = ns.getURI();
        Iterator i = this.attributes.iterator();
        while (i.hasNext()) {
            Attribute att = (Attribute)i.next();
            if (!att.getNamespaceURI().equals(uri) || !att.getName().equals(name)) continue;
            i.remove();
            att.setParent(null);
            return true;
        }
        return false;
    }

    public boolean removeChild(String name) {
        return this.removeChild(name, Namespace.NO_NAMESPACE);
    }

    public boolean removeChild(String name, Namespace ns) {
        if (this.content == null) {
            return false;
        }
        String uri = ns.getURI();
        Iterator i = this.content.iterator();
        while (i.hasNext()) {
            Element element;
            Object obj = i.next();
            if (!(obj instanceof Element) || !(element = (Element)obj).getNamespaceURI().equals(uri) || !element.getName().equals(name)) continue;
            element.setParent(null);
            i.remove();
            return true;
        }
        return false;
    }

    public boolean removeChildren() {
        boolean deletedSome = false;
        if (this.content != null) {
            Iterator i = this.content.iterator();
            while (i.hasNext()) {
                Object obj = i.next();
                if (!(obj instanceof Element)) continue;
                Element element = (Element)obj;
                i.remove();
                element.setParent(null);
                deletedSome = true;
            }
        }
        return deletedSome;
    }

    public boolean removeChildren(String name) {
        return this.removeChildren(name, Namespace.NO_NAMESPACE);
    }

    public boolean removeChildren(String name, Namespace ns) {
        if (this.content == null) {
            return false;
        }
        String uri = ns.getURI();
        boolean deletedSome = false;
        Iterator i = this.content.iterator();
        while (i.hasNext()) {
            Element element;
            Object obj = i.next();
            if (!(obj instanceof Element) || !(element = (Element)obj).getNamespaceURI().equals(uri) || !element.getName().equals(name)) continue;
            element.setParent(null);
            i.remove();
            deletedSome = true;
        }
        return deletedSome;
    }

    public boolean removeContent(Comment comment) {
        if (this.content == null) {
            return false;
        }
        if (this.content.remove(comment)) {
            comment.setParent(null);
            return true;
        }
        return false;
    }

    public boolean removeContent(Element element) {
        if (this.content == null) {
            return false;
        }
        if (this.content.remove(element)) {
            element.setParent(null);
            return true;
        }
        return false;
    }

    public boolean removeContent(Entity entity) {
        if (this.content == null) {
            return false;
        }
        if (this.content.remove(entity)) {
            entity.setParent(null);
            return true;
        }
        return false;
    }

    public boolean removeContent(ProcessingInstruction pi) {
        if (this.content == null) {
            return false;
        }
        if (this.content.remove(pi)) {
            pi.setParent(null);
            return true;
        }
        return false;
    }

    public Element setAttributes(List attributes) {
        this.attributes = attributes;
        return this;
    }

    public Element setChildren(List children) {
        return this.setMixedContent(children);
    }

    protected Element setDocument(Document document) {
        this.document = document;
        return this;
    }

    public Element setMixedContent(List mixedContent) {
        if (this.content != null) {
            this.content.clear();
        } else {
            this.content = new LinkedList();
        }
        if (mixedContent != null) {
            this.content.addAll(mixedContent);
        }
        return this;
    }

    protected Element setParent(Element parent) {
        this.parent = parent;
        return this;
    }

    public Element setText(String text) {
        if (this.content != null) {
            this.content.clear();
        } else {
            this.content = new LinkedList();
        }
        if (text != null) {
            this.content.add(text);
        }
        return this;
    }

    public String toString() {
        StringBuffer stringForm = new StringBuffer(64).append("[Element: <").append(this.getQualifiedName());
        String nsuri = this.getNamespaceURI();
        if (!nsuri.equals("")) {
            stringForm.append(" [Namespace: ").append(nsuri).append("]");
        }
        stringForm.append("/>]");
        return stringForm.toString();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this.namespace.getPrefix());
        out.writeObject(this.namespace.getURI());
    }
}

